# coding: iso-8859-1


class Project


  #### 4.8 ####

  
  # Cre un projet XP ou 03 suivant le dossier du jeu
  def self.create(dossier_rm, dossier_dmk)
    if is_folder_rmxp?(dossier_rm) == true
      return Project_XP.new(dossier_rm, dossier_dmk)
    elsif is_folder_rm03?(dossier_rm)
      return Project_XP.new(dossier_rm, dossier_dmk)
    else
      raise(DMKW_Unknown_Project_Type.new(dossier_rm))
    end
  end





  def charger_dmk_4_3(path)
    return DA::marshal_read_pos(path, 1)
  end




  def charger_dmk_version(path, version)

    # On vrifie que le numro de version ne soit pas diffrent de la version
    # du logiciel
    if version != $dmk_version
      raise(DMKW_DMK_Bad_Version.new(version, $dmk_version, path))
    end

    # Chargement normal du fichier
    return charger_dmk_4_3(path)

  end





  def charger_dmk(path)

    begin
      version = DA::marshal_read(path)
    rescue DAE_Marshal_Open => e
      raise(DMKE_DMK_Open.new(path))
    rescue DAE_Marshal_Read => e
      raise(DMKE_DMK_Read.new(path))
    end


    begin
      return charger_dmk_version(path, version)
    rescue DAE_Marshal_Open => e
      puts e.message
      raise(DMKE_DMK_Open.new(path))
    rescue DAE_Marshal_Read => e
      puts e.message
      raise(DMKE_DMK_Read.new(path))
    end


  end




  # Liste les fichiers DMK d'un dossier
  def lister_dmk(path_dmk=@dossier_dmk, absolu=true)
    begin
      map = DA::files_reg(path_dmk, R_MAP_DMK, absolu)
      bd = DA::files_reg(path_dmk, R_BD_DMK, absolu)
    rescue DAE_No_Dir => e
      #puts e.message
      raise(DMKE_No_Dir_Data.new(path_dmk))
    end
    return map+bd
  end






  # Ecrit un fichier DMK sur le disque
  def ecrire_dmk(path, dmk)

    if $ecriture == false
      puts "(WRITE fake)"
      return
    end

    #p path
    begin
      DA::marshal_write(path, $dmk_version)
    rescue
      raise(DMKE_DMK_Write.new(path))
    end


    begin
      DA::marshal_write_add(path, dmk)
    rescue
      raise(DMKE_DMK_Write.new(path))
    end


    #if $rmxp == false
    #  nb_modif = trouve_nombre(map.liste[91], 0)
    #else
    #  nb_modif = "\000"
    #end
    #puts "nb_modif : #{nb_modif}"
    # Cration des informations pour faciliter les traitements de DMK
    #structure = Infos.new($dmk_version, nb_modif, modif_dmk)



  end




  # Ecrit un lment de BD DMK sur le disque
  def ecrire_bd_dmk(path, bd)


    begin
      DA::marshal_write(path, $dmk_version)
    rescue
      raise(DMKE_DMK_Write.new(path))
    end


    begin
      DA::marshal_write_add(path, bd)
    rescue
      raise(DMKE_DMK_Write.new(path))
    end

  end



  def dial_sauvegarder
    putss "#94 Sauvegarde du fichier suivant : %s", dial

    dial = self.dossier_local(F_DIAL)
    dial_save = self.dossier_local(F_DIAL_SAVE)

    FileUtils.cp(dial, dial_save)
    putss "#37 Copie de sauvegarde effectue : %s => %s", dial, dial_save

  end






  ###############################################################
  # Environnement
  ###############################################################


  # Retourne le dossier local, ventuellement avec un nom de fichier li
  def dossier_local(path=nil)
    return link_get(@dossier_local, path)
  end


  # Retourne le dossier DMK, ventuellement avec un nom de fichier li
  def path_dmk(path=nil)
    return link_get(@dossier_dmk, path)
  end

  # Retourne le dossier RM, ventuellement avec un nom de fichier li
  def path_rm(path=nil)
    return link_get(@dossier_rm, path)
  end



  # Lie un chemin de dossier et un nom de fichier si ce dernier est renseign
  def link_get(var, path)
    if path == nil
      return var
    else
      return File.join(var, path)
    end
  end




  # ETAPE 1
  #
  # Transforme les fichiers RM en fichiers DMK
  #
  def decompiler_liste(liste)
    a = Time.new

    for path_rm in liste
      # On spare le fichier
      begin
        file_dmk = decompiler_rm_test(path_rm)
      rescue DMKW_DMK_Incompatible => e
        Affichage::error(e.message)
        next
      rescue DMKE_Map_RM_Read, DMKE_Map_RM_Open => e
        Affichage::error(e.message)
        next
      end

      file_name = File.basename(path_rm)
      file_name = File.remplacer_extension(file_name, "dmk")

      path_dmk = self.path_dmk(file_name)

      # On crit la map dcompile sur le disque
      ecrire_dmk(path_dmk, file_dmk)

      # On met la liste des modifications  jour en indiquant
      # que les fichiers RMXP et DMK sont en accord
      modif_update_file(path_rm, false)
      modif_update_file(path_dmk, false)
    end



    t = Time.new-a
    puts_info "#4 %d fichiers RM dcompils en %.02f secondes.", liste.size, t
    

  end



  def compiler(toutes)

    type = "DMK"

    # Liste les fichiers RMXP du projet
    begin
      liste = lister_dmk_a_traiter(toutes, type)
    rescue DMKW_Vide_File, DMKW_Vide_File_Mod_Ajout => e
      # Le dossier est vide, ou ne contient aucun fichier modifi ou ajout
      Affichage::warning(e.message)
      raise(DMKW_Cancel.new)
    end

    liste_maps = liste.keep_reg(R_MAP_DMK)
    liste_db = liste-liste_maps

    a = Time.new
    putss "#32 Compilation des fichiers %s : ", type


    compiler_go_maps(liste_maps)
    compiler_go_db(liste_db)


    # S'il y a bien des maps ou lments de BD  traiter, on les traite
    #compiler_go(liste, type)


    modif_ecrire

    t = Time.new-a
    putss "#3 %d fichiers RM compils en %.02f secondes.", liste_maps.size+liste_db.size, t


  end






  #############
  


  def self.projet_creer
    # Cration du projet
    begin
      projet = self.new($e.dossier_rm, $e.dossier_dmk)
    rescue DMKE_No_Dir_Data => e
      Affichage::error(e.message)
      raise(DMKW_Cancel.new)
    end
    return projet
  end


  # Importation des dialogues avec gestion des erreurs
  def projet_texte(path)

    begin
      text = self.importer_dialogue(path)
    rescue DMKW_DMK_Vide => e
      # Cas o il n'y a ni maps ni BD
      Affichage::warning(e.message)
      raise(DMKW_Cancel.new)
    rescue DMKW_Dial_No_File => e
      # Cas o il n'y a pas de fichier dialogues
      Affichage::warning(e.message)
      raise(DMKW_Cancel.new)
    rescue DMKE_Dial_Open => e
      # Cas o il y a un problme d'ouverture du fichier dialogues
      Affichage::warning(e.message)
      raise(DMKW_Cancel.new)
    rescue DMKE_Dial_Read => e
      # Cas o il y a un problme de lecture du fichier dialogues
      Affichage::warning(e.message)
      raise(DMKW_Cancel.new)
    rescue DMKW_Dial_No_In_File => e
      # Cas o il n'y a pas de dialogues dans le fichier
      Affichage::warning(e.message)
      raise(DMKW_Cancel.new)
    end

    return text

  end





  def lister_rm_modif(dossier)

    liste = []

    # Si le fichier des modifications existe bien, on rcupre ses infos
    modif_info = modif_lire

    
    for file, infos in modif_info
      if $rmxp == true
        next if file.regexp_egal(R_MAP_RMXP, R_BD_RMXP) == false
      else
        next if R_MAP_RM03.match(file) == nil
      end
      
      path_file = dossier.join(file)
      begin
        # On regarde si le fichier a t modifi
        if modif_fichier?(path_file) == true
          # Si c'est le cas, on l'ajoute  la liste
          liste << path_file
        end
      rescue DMKW_Mod_No_File => e
        # Au cas o le fichier ne peut tre trouv
        Affichage::warning(e.message)
        # On le supprime de la liste des fichiers
        modif_delete_map(file)
      end
      
    end

    return liste

  end


  def lister_dmk_modif(dossier)

    liste = []

    # Si le fichier des modifications existe bien, on rcupre ses infos
    modif_info = modif_lire


    for file, infos in modif_info
      if $rmxp == true
        next if file.regexp_egal(R_MAP_DMK, R_BD_DMK) == false
      else
        next if R_MAP_RM03.match(file) == nil
      end

      path_file = dossier.join(file)
      begin
        # On regarde si le fichier a t modifi
        if modif_fichier?(path_file) == true
          # Si c'est le cas, on l'ajoute  la liste
          liste << path_file
        end
      rescue DMKW_Mod_No_File => e
        # Au cas o le fichier ne peut tre trouv
        Affichage::warning(e.message)
        # On le supprime de la liste des fichiers
        modif_delete_map(file)
      end

    end

    # On ajoute les fichiers dmk prsents dans le dossier mais pas dans le
    # fichier des modifications
    list_modif = modif_info.keys
    list_dmk =  DA::file_list_basename(dossier)
    list_add = list_dmk - list_modif
    for file in list_add
      if $rmxp == true
        next if file.regexp_egal(R_MAP_DMK, R_BD_DMK) == false
      else
        next if R_MAP_RM03.match(file) == nil
      end
      
      liste << dossier.join(file)
    end
    

    return liste

  end




  def lister_rm_ajout(dossier_rm, dossier_dmk)
    if $rmxp == true
      ext_avant = "rxdata"
    else
      ext_avant = "lmu"
    end

    lister_ajout(dossier_rm, dossier_dmk, ext_avant)
  end


  def lister_dmk_ajout(dossier_rm, dossier_dmk)

    ext = "dmk"

    lst_orig = lister_rm(dossier_rm, false)
    lst_suppl = lister_dmk(dossier_dmk, false)

    #p lst_orig, lst_suppl

    lst_orig_ext = method_array(File, :forcer_extension, lst_orig, ext)

    lst_suppl -= lst_orig_ext

    lst_suppl_path = method_before_array(File, :join, dossier_dmk, lst_suppl)

    return lst_suppl_path

  end


  def lister_ajout(dossier_rm, dossier_dmk, ext_avant)

    #pa "lst_rm", lst_rm

    lst_avant = lister_dmk(dossier_dmk, false)
    lst_apres = lister_rm(dossier_rm, false)

    lst_avant_ext = method_array(File, :forcer_extension, lst_avant, ext_avant)

    lst_apres -= lst_avant_ext

    lst_ajout_path = method_before_array(File, :join, dossier_rm, lst_apres)


    #pa "lst_ajout", lst_ajout
    return lst_ajout_path

  end









end